const DEFAULTS = {
  waste: 10,
  adh: 3.0,
  grout: 0.8,
  quoteUrl: "https://vanwijngaardentegelzetters.nl/offerte-betegelen-badkamer-kosten/"
};

function getSettings() { return new Promise(res => chrome.storage.sync.get(DEFAULTS, res)); }
function setSettings(u) { return new Promise(res => chrome.storage.sync.set(u, res)); }

function ceil(n, dec=2) {
  const f = Math.pow(10, dec);
  return Math.ceil(n * f) / f;
}

async function init(){
  const s = await getSettings();
  document.getElementById("waste").value = s.waste;
  document.getElementById("adh").value = s.adh;
  document.getElementById("grout").value = s.grout;
  document.getElementById("quote").href = s.quoteUrl;

  document.getElementById("calc").addEventListener("click", calc);
  document.getElementById("reset").addEventListener("click", () => {
    ["len","wid","tw","th"].forEach(id => document.getElementById(id).value = "");
    ["area","tiles","adh_kg","grout_kg"].forEach(id => document.getElementById(id).textContent = "—");
  });
}

function calc(){
  const L = parseFloat(document.getElementById("len").value);
  const W = parseFloat(document.getElementById("wid").value);
  const tw = parseFloat(document.getElementById("tw").value); // cm
  const th = parseFloat(document.getElementById("th").value); // cm
  const joint_mm = parseFloat(document.getElementById("joint").value);
  const waste = parseFloat(document.getElementById("waste").value) / 100.0;
  const adh = parseFloat(document.getElementById("adh").value);
  const grout = parseFloat(document.getElementById("grout").value);

  if ([L,W,tw,th,joint_mm].some(x => isNaN(x) || x <= 0)) {
    alert("Vul alle afmetingen in.");
    return;
  }

  const area = L * W; // m2
  // Tile area in m2 (ignore joint for count; waste covers it)
  const tileArea = (tw/100.0) * (th/100.0);
  let tiles = Math.ceil((area / tileArea) * (1 + waste));

  const adhKg = ceil(area * adh, 2);
  const groutKg = ceil(area * grout, 2);

  document.getElementById("area").textContent = ceil(area, 2).toFixed(2);
  document.getElementById("tiles").textContent = tiles.toString();
  document.getElementById("adh_kg").textContent = adhKg.toFixed(2);
  document.getElementById("grout_kg").textContent = groutKg.toFixed(2);
}

init();